﻿#pragma once
//ESTRUCTURAS EXPUESTAS AL EXTERIOR
#include <ATsistemas/ClaseSistema.h>
#include "ClasesGPS.h"
typedef struct{
	float im;
	float pXY, pZ;
	float gpsXY, gpsZ;
	float insΩΦ, insK;
} Precisiones;

//Número de decimales con que deben darse los valores ajustados
//Un valor menor que 0 indicaría que se puede redondear a la correspondiente potencia de 10
typedef struct{
	sint8m f;	//Sólo se usa para los parámetros de autocalibración
	sint8m pxy, pz;	//puntos xy, z
	sint8m cpxy, cpz, cpg, rot;	//centros de proyección xy, z, giros, matriz de rotación
} DecimalesAj;

//Posibles valores de tipo para la estructura NamedPointer
#define TIPOBNF_U	1		// uint
#define TIPOBNF_U2	2		// int2: struct{uint n1; uint n2;}
#define TIPOBNF_U3	3		// int3: struct{uint n1; uint n2; uint n3;}
#define TIPOBNF_U4	4		// int4: struct{uint n1; uint n2; uint n3; uint n4;}
#define TIPOBNF_C	5		// char8_t
#define TIPOBNF_W	6		// char16_t
#define TIPOBNF_F	7		// float
#define TIPOBNF_D	8		// double
#define TIPOBNF_CP	9		// CentroProy
#define TIPOBNF_PM 10	// PuntoM
#define TIPOBNF_PI	11		// PuntoGPSINS
#define TIPOBNF_GP	12		// GrupoGPSINS

#define TIPOBNF_MAX 12

//Sizeof de cada uno de los anteriores
static const uint NamedPointersSizeof[]={
	0,
	usizeof(uint),
	usizeof(int2),
	usizeof(int3),
	usizeof(int4),
	usizeof(char8_t),
	usizeof(char16_t),
	usizeof(float),
	usizeof(double),
	usizeof(CentroProy),
	usizeof(PuntoM),
	usizeof(PuntoGPSINS),
	usizeof(GrupoGPSINS),
};

typedef struct {
	uint tipo;
	const char8_t* name;
	uint n;	//Número de elementos
	void* p;
} NamedPointer;

typedef struct{
	const char8_t* name;
	uint n;
} Namedn;

//Para saber si hay o no residuos de cada tipo de observaciones se mira su correspondiente redundancia parcial
typedef struct{
	char16_t* ficherof;
	char16_t* ficheroapr;
	char16_t* ficheroapy;
	char16_t* ficherogps;
	char16_t* ficheroint;
	struct{
		uint8m mar, prm, pym, gpm, inm;
	} tipos_fich;
	uint8m uni;		//unidades de los giros
	Sistema sis;
	uint8m estimador;	//v. clases_estimadores

	struct{
		uint ncp, npm, npy, ngruposgps,ngps, ngruposins,nins, ngruposcalib;
	} ncalc;
	Precisiones apriori;		//Los valores para magnitudes angulares,
	Precisiones aposteriori;	//INSΩΦ e INSK, están en radianes
	float σ_aposteriori;	/*En relación a los valores a priori*/
	struct{
		float foto, apoyo, gps, ins;
	} redun_parciales;
	uint nobs;
	uint nincog;
	DecimalesAj decj;
} BnfVarios;

typedef struct{
	PLIST plist;
	NamedPointer* punteros;
	Namedn* enes;
	BnfVarios *varios;
} FicheroBnf;

//Nombres de arrays y enteros definidos
static const char8_t* const bnf_nombres_enteros[]={
	"n fotogramas", //0
	"n CentrosProy", //1
	"n PuntosM", //2
	"n puntosA", //3
	"n puntosC", //4
	"n GruposNAV", //5
	"n gpss", //6
	"n inss", //7
	"n observaciones", //8
};
#define BNF_N_ENTEROS 9

static const char8_t* const bnf_nombres_punteros[]={
	"Nombres fotogramas", //0
	"Nombres puntosf", //1
	"Nombres puntosA", //2
	"Nombres gpss", //3
	"CentrosProy", //4
	"PuntosModelo", //5
	"puntosApoyo", //6
	"puntosControl", //7
	"gpss", //8
	"GruposNAV", //9
	"puntosC_a_puntosA", //10
	"Acumulado GruposNAV", //11
	"Calc_a_orig GruposNAV", //12
	"observaciones", //13
	"Acumulado CentrosProy", //14
	"PuntoM_en_CentroProy", //15
	"Ppios PuntoM_en_CP", //16
	"puntosC_a_PuntosM", //17
	"puntosA_a_PuntosM", //18
	"Orden CentrosProy", //19
	"Orden PuntosM", //20
	"L puntosf", //21
	"L puntosA", //22
	"L gpss", //23
	"L inss", //24
	"Lnorm puntosf", //25
	"Lnorm puntosA", //26
	"Lnorm gpss", //27
	"Lnorm inss", //28
	"L puntosC", //29
	"Lnorm puntosC", //30
};
#define BNF_N_PUNTEROS 31

//Tipos de filas que rellenan las funciones que rellenan
typedef struct{
	const char8_t* f1_fotograma;
	const char8_t* f2_punto;
	char8_t f3_resx[12];
	char8_t f4_resy[12];
	char8_t f5_tipo[4]; //XYZ
	float f6_res_norm_x;
	float f7_res_norm_y;
	char8_t f8_aviso[4]; //!!
	float v_resx;
	float v_resy;
	uint v_orden_def;
	uint v_orden_res;
	uint v_orden_res_norm;
} BnfFila_ResporFoto;

typedef struct{
	const char8_t* f1_punto;
	const char8_t* f2_fotograma; // o bien el tipo (XYZ)
	char8_t f3_resx[12]; // o bien el aviso (!!)
	char8_t f4_resy[12];
	float f5_res_norm_x;
	float f6_res_norm_y;
	float v_resx;
	float v_resy;
	uint v_orden_def;
	uint v_orden_res;
	uint v_orden_res_norm;
} BnfFila_ResporPunto;

typedef struct{
	const char8_t* f1_punto;
	char8_t f2_resx[12];
	char8_t f3_resy[12];
	char8_t f4_resz[12];
	float f5_res_norm_x;
	float f6_res_norm_y;
	float f7_res_norm_z;
	float v_resx;
	float v_resy;
	float v_resz;
	uint v_orden_def;
	uint v_orden_res;
	uint v_orden_res_norm;
} BnfFila_ResApoyo;

typedef struct{
	const char8_t* f1_grupo;
	const char8_t* f2_centroproy;
	char8_t f3_resx[12];
	char8_t f4_resy[12];
	char8_t f5_resz[12];
	char8_t f6_resw[12];
	char8_t f7_resfi[12];
	char8_t f8_resk[12];
	float f9_res_norm_x;
	float f10_res_norm_y;
	float f11_res_norm_z;
	float f12_res_norm_w;
	float f13_res_norm_fi;
	float f14_res_norm_k;
} BnfFila_ResGPS;

typedef struct{BnfFila_ResporFoto *filas; uint nfilas;} BnfTabla_ResporFoto;
typedef struct{BnfFila_ResporPunto *filas; uint nfilas;} BnfTabla_ResporPunto;
typedef struct{BnfFila_ResApoyo *filas; uint nfilas;} BnfTabla_ResApoyo;
typedef struct{BnfFila_ResGPS *filas; uint nfilas;} BnfTabla_ResGPS;
